#include "ulamek.h"

template <class T> inline double ulamek<T>::to_double() const
    {
    return licznik/(double)mianownik;
    }
template <class T> char* ulamek<T>::to_string() const
    {
    char str_licznik[ulamek_maxstr]; itoa(licznik,str_licznik,10);
    char str_mianownik[ulamek_maxstr]; itoa(mianownik,str_mianownik,10);
    char* str=str_licznik;
    strcat(str,"/");
    strcat(str,str_mianownik);
    return str;
    }
template <class T> void ulamek<T>::set(T alicznik,T amianownik)
    {
    if (amianownik==0) throw "Ulamek: Blad #1";
    licznik=alicznik;
    mianownik=amianownik;
    }
template <class T> void ulamek<T>::simplify()
    {
    //NWD
    T mniejsza=(abs(licznik)<abs(mianownik))?abs(licznik):abs(mianownik);
    for(T i=mniejsza;i>0;i--)
        if ((licznik%i==0) && (mianownik%i==0))
                {
                licznik/=i;
                mianownik/=i;
                }
            //znaki
        if (licznik*mianownik<0)
                {
                licznik=-abs(licznik);
                mianownik=abs(mianownik);
                }
                else
                {
                licznik=abs(licznik);
                mianownik=abs(mianownik);
                }
         }
template <class T> inline void ulamek<T>::get(T& rlicznik,T& rmianownik) const
    {
    rlicznik=licznik;
    rmianownik=mianownik;
    }
template <class T> inline void ulamek<T>::get(T* plicznik,T* pmianownik) const
    {
    *plicznik=licznik;
    *pmianownik=mianownik;
    }


template <class T> ulamek<T> operator *(const ulamek<T>& aulamek1,const ulamek<T>& aulamek2)
    {
    T alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    T alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return ulamek<T>(alicznik1*alicznik2,amianownik1*amianownik2);
    };
template <class T> ulamek<T> operator /(const ulamek<T>& aulamek1,const ulamek<T>& aulamek2)
    {
    T alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    T alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return ulamek<T>(alicznik1*amianownik2,amianownik1*alicznik2);
    };
template <class T> ulamek<T> operator +(const ulamek<T>& aulamek1,const ulamek<T>& aulamek2)
    {
    T alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    T alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return ulamek<T>(alicznik1*amianownik2+alicznik2*amianownik1,amianownik1*amianownik2);
    };
template <class T> ulamek<T> operator -(const ulamek<T>& aulamek1)
    {
    T alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    return ulamek<T>(-alicznik1,amianownik1);
    };
template <class T> ulamek<T> operator -(const ulamek<T>& aulamek1,const ulamek<T>& aulamek2)
    {
    T alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    T alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return ulamek<T>(alicznik1*amianownik2-alicznik2*amianownik1,amianownik1*amianownik2);
    };
template <class T> bool operator <(const ulamek<T>& aulamek1,const ulamek<T>& aulamek2)
    {
    T alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    T alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return (alicznik1/(double)amianownik1)<(alicznik2/(double)amianownik2);
    };
template <class T> bool operator >(const ulamek<T>& aulamek1,const ulamek<T>& aulamek2)
    {
    T alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    T alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return (alicznik1/(double)amianownik1)>(alicznik2/(double)amianownik2);
    };
template <class T> bool operator ==(const ulamek<T>& aulamek1,const ulamek<T>& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return (alicznik1/(double)amianownik1)==(alicznik2/(double)amianownik2);
    };
